//
//  Victory.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//

import SpriteKit
import SPCScene
import Canvas

public class Victory : Scene, SceneAnimating {
    static let pathIdentifier = "victorySequence-1024-%02d"
    var background: Graphic
    
    public override init() {
        let img = UIImage(named: "victorySequence-1024-01")!
        background = Graphic(image: Image(with: img), name: "Victory background")
        
        super.init(size: Scene.sceneSize)
        self.place(background, at: Point.center)
    }

    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    // MARK: - SceneAnimating
    
    public var sceneTransition: SKTransition?
    public var animationDelegate: SceneAnimatingDelegate?
    public var loadingDescription: String? {
        didSet {
            enableAccessibility(label: loadingDescription!)
        }
    }
    
    public func sceneIsPresented() {
        if let desc = loadingDescription {
            UIAccessibility.post(notification: .announcement, argument: desc)
        }
        
        var bgs: [Image] = []
        var index = 1
        while index < 24 {
            let path = String(format: Victory.pathIdentifier, index)
            if let img = UIImage(named: path) {
                bgs.append(Image(with: img))
            }
            index += 1
        }
        background.animate(with: bgs, fps: 5, loop: false)
    }
    
    public func sceneWillDismiss() {
        
    }
}
